return {
    min_layer = 1,
    max_layer = 8,
    shiftmode_keys = {[""] = true, ["1/2"] = true, ["2/2"] = true},
    symbolmode_keys = {["123"] = true, ["АБВ"] = true},
    utf8mode_keys = {["🌐"] = true},
    umlautmode_keys = {["БДС"] = true}, -- switch between phonetic and BDS, default is phonetic
    keys = {
        -- first row
        {  --  1       2       3       4       5       6       7       8
            { "Я",    "я",    "'",    "`",    "У",    "у",    "'",    "`",   },
            { "В",    "в",    "[",    "1",    "Е",    "е",    "[",    "1",   },
            { "Е",    "е",    "]",    "2",    "И",    "и",    "]",    "2",   },
            { "Р",    "р",    "{",    "3",    "Ш",    "ш",    "{",    "3",   },
            { "Т",    "т",    "}",    "4",    "Щ",    "щ",    "}",    "4",   },
            { "Ъ",    "ъ",    "#",    "5",    "К",    "к",    "#",    "5",   },
            { "У",    "у",    "%",    "6",    "С",    "с",    "%",    "6",   },
            { "И",    "и",    "^",    "7",    "Д",    "д",    "^",    "7",   },
            { "О",    "о",    "*",    "8",    "З",    "з",    "*",    "8",   },
            { "П",    "п",    "+",    "9",    "Ц",    "ц",    "+",    "9",   },
            { "Ю",    "ю",    "=",    "0",    "Б",    "б",    "=",    "0",   },
        },
        -- second row
        {  --  1       2       3       4       5       6       7       8
            { "А",    "а",    "§",    "+",    "Ь",    "ь",    "§",    "+",   },
            { "С",    "с",    "_",    "-",    "Я",    "я",    "_",    "-",   },
            { "Д",    "д",    "\\",   "/",    "А",    "а",    "\\",   "/",   },
            { "Ф",    "ф",    "|",    ":",    "О",    "о",    "|",    ":",   },
            { "Г",    "г",    "~",    ";",    "Ж",    "ж",    "~",    ";",   },
            { "Х",    "х",    "<",    "(",    "Г",    "г",    "<",    "(",   },
            { "Й",    "й",    ">",    ")",    "Т",    "т",    ">",    ")",   },
            { "К",    "к",    "$",    "€",    "Н",    "н",    "$",    "€",   },
            { "Л",    "л",    "£",    "&",    "В",    "в",    "£",    "&",   },
            { "Ш",    "ш",    "¥",    "@",    "М",    "м",    "¥",    "@",   },
            { "Щ",    "щ",    "№",    "”",    "Ч",    "ч",    "№",    "”",   },
        },
        -- third row
        {  --  1       2       3       4       5       6       7       8
            { "",   "",    "2/2",  "1/2",   "",   "",   "2/2",    "1/2",
              width = 1.0
            },
            { "З",    "з",    "–",    "–",    "Ю",    "ю",    "–",    "–",   },
            { "Ь",    "ь",    "—",    "—",    "Й",    "й",    "—",    "—",   },
            { "Ц",    "ц",    ".",    ".",    "Ъ",    "ъ",    ".",    ".",   },
            { "Ж",    "ж",    ",",    ",",    "Э",    "э",    ",",    ",",   },
            { "Б",    "б",    "?",    "?",    "Ф",    "ф",    "?",    "?",   },
            { "Н",    "н",    "!",    "!",    "Х",    "х",    "!",    "!",   },
            { "М",    "м",    "’",    "’",    "П",    "п",    "’",    "’",   },
            { "Ч",    "ч",    "↑",    "↑",    "Р",    "р",    "↑",    "↑",   },
            { "Э",    "э",    '"',    "|",    "Л",    "л",    '"',    "|",   },
            { label = "",
              width = 1.0,
              bold = false
            },
        },
        -- fourth row
        {
            { "123",  "123",  "АБВ",  "АБВ",  "123",  "123",  "АБВ",  "АБВ",
              width = 1.0},
            { label = "🌐", },
            { "БДС",  "БДС",  "БДС",  "БДС",  "БДС",  "БДС",  "БДС",  "БДС", },
            { label = "интервал",
              " ",    " ",    " ",    " ",    " ",    " ",    " ",    " ",
              width = 4.0},
            { "?",    "?",    "←",    "←",    "?",    "?",    "←",    "←", },
            { ",",    ",",    "↓",    "↓",    ",",    ",",    "↓",    "↓", },
            { ".",    ".",    "→",    "→",    ".",    ".",    "→",    "→", },
            { label = "⮠",
              "\n",   "\n",   "\n",   "\n",   "\n",   "\n",   "\n",   "\n",
              width = 1.0,
              bold = true
            },
        },
    },
}
